function CDX = set_k(CDX, k, dates)
% --------------------------------------------------------------------------------------------------
% Set mean reversion speed for common and idionsyncratic factors
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% k         ... desired speed of mean reversion
% dates     ... dates for which to set parameters, if k of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_k(CDX_NA_IG, 0.3, CDX_NA_IG.dates{1})
% --------------------------------------------------------------------------------------------------

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 2)
    % Set value for common factor
    CDX.AJD_common_factor.k = k;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).AJD.k = k;
    end
    return
end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.k(used_pos_cdx,:) = k(used_pos_params,:);
clear trash used_pos_cds used_pos_params

% Set value for individual CDS
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cds, used_pos_params] = intersect_sorted(cds.dates{1}, dates);
    cds.AJD.k(used_pos_cds,:) = k(used_pos_params,:);
    CDX.portfolio(i) = cds;
    clear trash used_pos_cds used_pos_params
end